﻿using System;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using PpmsDataWebService.Models;
using PpmsDataWebService.ModelsEnumTypes;

namespace PpmsDataWebService.Models
{
    public class VaProviderRelationship
    {
        [Key]
        public string Name { get; set; }

        public RelationshipType RelationshipType { get; set; }

        public string CredentialName { get; set; }

        public DateTime? StartDate { get; set; }

        public DateTime? EndDate { get; set; }

        //Single
        public virtual IQueryable<ProviderCredential> Credentialing { get; set; }

        //Many
        public virtual IQueryable<AgreementProvider> AgreementProviders { get; set; }

        //Many
        public virtual IQueryable<ProviderService> ProviderServices { get; set; }

        public virtual IQueryable<ProviderNetwork> ProviderNetworks { get; set; }

    }
}